<?php
/**
 * Timber starter-theme
 * https://github.com/timber/starter-theme
 *
 * @package  WordPress
 * @subpackage  Timber
 * @since   Timber 0.1
 */

/**
 * If you are installing Timber as a Composer dependency in your theme, you'll need this block
 * to load your dependencies and initialize Timber. If you are using Timber via the WordPress.org
 * plug-in, you can safely delete this block.
 */
$composer_autoload = __DIR__ . '/vendor/autoload.php';
if ( file_exists( $composer_autoload ) ) {
	require_once $composer_autoload;
	$timber = new Timber\Timber();
}

/**
 * This ensures that Timber is loaded and available as a PHP class.
 * If not, it gives an error message to help direct developers on where to activate
 */
if ( ! class_exists( 'Timber' ) ) {

	add_action(
		'admin_notices',
		function() {
			echo '<div class="error"><p>Timber not activated. Make sure you activate the plugin in <a href="' . esc_url( admin_url( 'plugins.php#timber' ) ) . '">' . esc_url( admin_url( 'plugins.php' ) ) . '</a></p></div>';
		}
	);

	add_filter(
		'template_include',
		function( $template ) {
			return get_stylesheet_directory() . '/static/no-timber.html';
		}
	);
	return;
}

/**
 * Sets the directories (inside your theme) to find .twig files
 */
Timber::$dirname = array( 'templates', 'views' );

/**
 * By default, Timber does NOT autoescape values. Want to enable Twig's autoescape?
 * No prob! Just set this value to true
 */
Timber::$autoescape = false;


/**
 * We're going to configure our theme inside of a subclass of Timber\Site
 * You can move this to its own file and include here via php's include("MySite.php")
 */
class StarterSite extends Timber\Site {
	/** Add timber support. */
	public function __construct() {
		add_action( 'after_setup_theme', array( $this, 'theme_supports' ) );
		add_filter( 'timber/context', array( $this, 'add_to_context' ) );
		add_filter( 'timber/twig', array( $this, 'add_to_twig' ) );
		add_action( 'init', array( $this, 'register_post_types' ) );
		add_action( 'init', array( $this, 'register_taxonomies' ) );
		parent::__construct();
	}
	/** This is where you can register custom post types. */
	public function register_post_types() {

	}
	/** This is where you can register custom taxonomies. */
	public function register_taxonomies() {

	}

	/** This is where you add some context
	 *
	 * @param string $context context['this'] Being the Twig's {{ this }}.
	 */
	public function add_to_context( $context ) {
		$context['foo']   = 'bar';
		$context['stuff'] = 'I am a value set in your functions.php file';
		$context['notes'] = 'These values are available everytime you call Timber::context();';
		$context['menu']  = new Timber\Menu();
		$context['site']  = $this;
		return $context;
	}

	public function theme_supports() {
		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support(
			'html5',
			array(
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
			)
		);

		/*
		 * Enable support for Post Formats.
		 *
		 * See: https://codex.wordpress.org/Post_Formats
		 */
		add_theme_support(
			'post-formats',
			array(
				'aside',
				'image',
				'video',
				'quote',
				'link',
				'gallery',
				'audio',
			)
		);

		add_theme_support( 'menus' );
	}

	/** This Would return 'foo bar!'.
	 *
	 * @param string $text being 'foo', then returned 'foo bar!'.
	 */
	public function myfoo( $text ) {
		$text .= ' bar!';
		return $text;
	}

	/** This is where you can add your own functions to twig.
	 *
	 * @param string $twig get extension.
	 */
	public function add_to_twig( $twig ) {
		$twig->addExtension( new Twig\Extension\StringLoaderExtension() );
		$twig->addFilter( new Twig\TwigFilter( 'myfoo', array( $this, 'myfoo' ) ) );
		return $twig;
	}

}

new StarterSite();

add_filter( 'timber/context', 'add_to_context' );

function add_to_context( $context ) {
	$args = array(
		'depth' => 1,
	);
	$context['menu'] = new \Timber\Menu( 'main-nav', $args );
	$context['about_menu'] = new \Timber\Menu( 'about-nav', $args );
	$context['top_menu'] = new \Timber\Menu( 'top-nav', $args );
	$context['footer_menu'] = new \Timber\Menu( 'footer-nav', $args );
    return $context;
}

function my_enqueue_scripts() {
	wp_enqueue_script(
		'jquery-scripts',
		'https://d3e54v103j8qbb.cloudfront.net/js/jquery-3.4.1.min.220afd743d.js', '', '', true
	);
	wp_enqueue_script(
		'sticky-script',
		get_template_directory_uri() .'/static/js/jquery.stickybits.min.js', '', '', true
	);	
	if( is_front_page() ){
		wp_enqueue_script(
			'handlebars-scripts',
			get_template_directory_uri() .'/static/js/lightbox.min.js', '', '', true
		);	
	}
	if( is_page('careers') ){
		wp_enqueue_script(
			'handlebars-scripts',
			get_template_directory_uri() .'/static/js/lightbox.min.js', '', '', true
		);	
	}	
	if( is_page('locations') ){
		wp_enqueue_script(
			'gmaps-scripts',
			'https://maps.googleapis.com/maps/api/js?client=gme-reliancesteelaluminum&libraries=places', '', '', true
		);	
		wp_enqueue_script(
			'handlebars-scripts',
			get_template_directory_uri() .'/static/js/libs/handlebars.min.js', '', '', true
		);	
	}
	if( is_page('our-history') ) {
		wp_enqueue_script(
			'migrate',
			'https://code.jquery.com/jquery-migrate-1.2.1.min.js', '', '', true
		);	
		wp_enqueue_script(
			'slick-scripts',
			get_template_directory_uri() .'/static/js/slick.min.js', '', '', true
		);	
	}	
}
add_action( 'wp_enqueue_scripts', 'my_enqueue_scripts' );

add_action("wp_enqueue_scripts", "auto_version_scripts", 20);
function auto_version_scripts() {
	$ttime = filemtime( get_stylesheet_directory() . '/rsac.css' );
	$stime = filemtime( get_stylesheet_directory() . '/style.css' );
	$slcsstime = filemtime( get_stylesheet_directory() . '/static/css/storelocator.css' );
	$lbtime = filemtime( get_stylesheet_directory() . '/static/css/magnific-popup.css' );
	$juicsstime = filemtime( get_stylesheet_directory() . '/static/css/jquery-ui.css' );

	$jtime = filemtime( get_stylesheet_directory() . '/static/js/rsac.js' );
	$htime = filemtime( get_stylesheet_directory() . '/static/js/home.js' );
	$ctime = filemtime( get_stylesheet_directory() . '/static/js/companies.js' );
	$ltime = filemtime( get_stylesheet_directory() . '/static/js/leadership.js' );
	$sljstime = filemtime( get_stylesheet_directory() . '/static/js/jquery.storelocator.js' );
	$ltime = filemtime( get_stylesheet_directory() . '/static/js/locations.js' );
	$juitime = filemtime( get_stylesheet_directory() . '/static/js/jquery-ui.min.js' );
	$histime = filemtime( get_stylesheet_directory() . '/static/js/history.js' );
	$cartime = filemtime( get_stylesheet_directory() . '/static/js/careers.js' );

	wp_enqueue_style(
		'theme_style', // handle for style.css
		get_template_directory_uri() .'/rsac.css' ,
		array(), // dependencies
		$ttime, // version number
		false // load in footer
	);
	wp_enqueue_style(
		'custom_style', // handle for style.css
		get_template_directory_uri() .'/style.css' ,
		array(), // dependencies
		$stime, // version number
		false // load in footer
	);
	if( is_front_page() ){
		wp_enqueue_style(
			'popup_style', // handle for style.css
			get_template_directory_uri() .'/static/css/magnific-popup.css' ,
			array(), // dependencies
			$lbtime, // version number
			false // load in footer
		);
	}	
	if( is_page('careers') ){
		wp_enqueue_style(
			'popup_style', // handle for style.css
			get_template_directory_uri() .'/static/css/magnific-popup.css' ,
			array(), // dependencies
			$lbtime, // version number
			false // load in footer
		);
	}		
	wp_enqueue_script(
		'theme_js', // handle for main.js
		get_template_directory_uri() .'/static/js/rsac.js' ,
		array(), // dependencies
		$jtime, // version number
		true // load in footer
	);
	if( is_front_page() ){
		wp_enqueue_script(
			'home_js', // handle for main.js
			get_template_directory_uri() .'/static/js/home.js' ,
			array(), // dependencies
			$htime, // version number
			true // load in footer
		);
	}
	if( is_page('our-family-of-companies') ){
		wp_enqueue_script(
			'companies_js', // handle for main.js
			get_template_directory_uri() .'/static/js/companies.js' ,
			array(), // dependencies
			$ctime, // version number
			true // load in footer
		);
	}
	if( is_page('our-leadership') ){
		wp_enqueue_script(
			'leadership_js', // handle for main.js
			get_template_directory_uri() .'/static/js/leadership.js' ,
			array(), // dependencies
			$ltime, // version number
			true // load in footer
		);
	}	
	if( is_page('careers') ){
		wp_enqueue_script(
			'careers_js', // handle for main.js
			get_template_directory_uri() .'/static/js/careers.js' ,
			array(), // dependencies
			$cartime, // version number
			true // load in footer
		);
	}		
	if( is_page('locations') ){
		wp_enqueue_style(
			'sl_style', // handle for style.css
			get_template_directory_uri() .'/static/css/storelocator.css' ,
			array(), // dependencies
			$slcsstime, // version number
			false // load in footer
		);
		wp_enqueue_style(
			'jquery_ui_style', // handle for style.css
			get_template_directory_uri() .'/static/css/jquery-ui.css' ,
			array(), // dependencies
			$juicsstime, // version number
			false // load in footer
		);
		wp_enqueue_script(
			'jquery_ui_js', // handle for main.js
			get_template_directory_uri() .'/static/js/jquery-ui.min.js' ,
			array(), // dependencies
			$juitime, // version number
			true // load in footer
		);				
		wp_enqueue_script(
			'custom_locations_js', // handle for main.js
			get_template_directory_uri() .'/static/js/locations.js' ,
			array(), // dependencies
			$ltime, // version number
			true // load in footer
		);		
		wp_enqueue_script(
			'locations_js', // handle for main.js
			get_template_directory_uri() .'/static/js/jquery.storelocator.js' ,
			array(), // dependencies
			$sljstime, // version number
			true // load in footer
		);
	}
	if( is_page('our-history') ){
		wp_enqueue_script(
			'history_js', // handle for main.js
			get_template_directory_uri() .'/static/js/history.js' ,
			array(), // dependencies
			$histime, // version number
			true // load in footer
		);
	}
}

// Our custom post type function
function create_posttype() {
 
    register_post_type( 'companies',
        array(
            'labels' => array(
                'name' => __( 'Companies' ),
                'singular_name' => __( 'Company' )
            ),
            'public' => true,
            'has_archive' => false,
			'rewrite' => array('slug' => 'companies'),
			'menu_icon'           => 'dashicons-groups',
			'show_in_menu'        => true,
			'show_in_nav_menus'   => false,
			'exclude_from_search' => true,
			'publicly_queryable'  => true,
        )
    );
}
// Hooking up our function to theme setup
add_action( 'init', 'create_posttype' );

function wpcf_create_temp_column($fields) {
	global $wpdb;
	$matches = 'A|An|The|La|Les';
	$has_the = " CASE 
		WHEN $wpdb->posts.post_title regexp( '^($matches)[[:space:]]' )
		  THEN trim(substr($wpdb->posts.post_title from 4)) 
		ELSE $wpdb->posts.post_title 
		  END AS title2";
	if ($has_the) {
	  $fields .= ( preg_match( '/^(\s+)?,/', $has_the ) ) ? $has_the : ", $has_the";
	}
	return $fields;
}
  
function wpcf_sort_by_temp_column ($orderby) {
	$custom_orderby = " UPPER(title2) ASC";
	if ($custom_orderby) {
	  $orderby = $custom_orderby;
	}
	return $orderby;
}

add_filter('posts_fields', 'wpcf_create_temp_column');
add_filter('posts_orderby', 'wpcf_sort_by_temp_column');

function replace_text($value) {
	$value = str_replace('|', '<br />', $value);
	return $value;
}
add_filter('acf/format_value/type=text', 'replace_text', 10, 3);
add_filter('acf/format_value/type=textarea', 'replace_text', 10, 3);
// add_filter('acf/update_value/type=textarea', 'replace_text', 10, 3);
add_filter('acf/update_value/name=description_of_company', 'replace_text', 10, 3);


?>